<?php
// Include database connection
include 'conn.php';

// Initialize variables
$book_no = "";
$book_name = "";
$form = "";
$message = "";

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['search'])) {
        // Retrieve and sanitize form data
        $book_no = $_POST['book_no'];
        $book_no = $conn->real_escape_string($book_no);

        // Query the database for the book details
        $sql = "SELECT * FROM books WHERE book_no='$book_no'";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $book = $result->fetch_assoc();
            $book_name = $book['book_name'];
            $form = $book['form'];

            // Check if the book_no exists in books_already_given
            $check_given_sql = "SELECT * FROM books_already_given WHERE book_no='$book_no'";
            $check_given_result = $conn->query($check_given_sql);

            if ($check_given_result->num_rows > 0) {
                $message = "<div class='message error'>This book cannot be edited as it is already given out.</div>";
                $book_name = "";
                $form = "";
            }
        } else {
            $message = "<div class='message error'>No record found for Book Number: $book_no</div>";
        }
    } elseif (isset($_POST['update'])) {
        // Retrieve and sanitize form data
        $book_no = $_POST['book_no'];
        $book_name = $_POST['book_name'];
        $form = $_POST['form'];

        $book_no = $conn->real_escape_string($book_no);
        $book_name = $conn->real_escape_string($book_name);
        $form = $conn->real_escape_string($form);

        // Check if the book_no exists in books_already_given
        $check_given_sql = "SELECT * FROM books_already_given WHERE book_no='$book_no'";
        $check_given_result = $conn->query($check_given_sql);

        if ($check_given_result->num_rows > 0) {
            $message = "<div class='message error'>This book cannot be updated as it is already given out.</div>";
        } else {
            // Update data in the database
            $sql = "UPDATE books SET book_name='$book_name', form='$form' WHERE book_no='$book_no'";

            if ($conn->query($sql) === TRUE) {
                $message = "<div class='message success'>Record updated successfully</div>";
            } else {
                $message = "<div class='message error'>Error: " . $sql . "<br>" . $conn->error . "</div>";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Book</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background: #f0f4f8;
        }
        .navbar {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background: #ffffff;
            border-bottom: 1px solid #ddd;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            padding: 10px 20px;
            display: flex;
            align-items: center;
            z-index: 1000;
            backdrop-filter: blur(8px);
            box-sizing: border-box;
        }
        .navbar .nav-links {
            display: flex;
            flex: 1;
            justify-content: center;
        }
        .navbar .nav-links a {
            text-decoration: none;
            color: #007bff;
            font-size: 16px;
            margin: 0 15px;
            font-weight: 500;
            display: flex;
            align-items: center;
            position: relative;
            transition: color 0.3s ease;
        }
        .navbar .nav-links a i {
            margin-right: 8px;
        }
        .navbar .nav-links a:hover {
            color: #0056b3;
        }
        .navbar .nav-links .dropdown {
            position: relative;
            display: inline-block;
        }
        .navbar .nav-links .dropdown-content {
            display: none;
            position: absolute;
            background-color: #ffffff;
            min-width: 160px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.2);
            z-index: 1;
            top: 100%;
            left: 0;
        }
        .navbar .nav-links .dropdown-content a {
            color: #007bff;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
        }
        .navbar .nav-links .dropdown-content a:hover {
            background-color: #f1f1f1;
        }
        .navbar .nav-links .dropdown:hover .dropdown-content {
            display: block;
        }
        .container {
            width: 90%;
            max-width: 480px;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            margin: 80px auto 20px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .container:hover {
            transform: scale(1.02);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
            position: relative;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #666;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-sizing: border-box;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }
        .form-group input:focus {
            border-color: #007bff;
            outline: none;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.3);
        }
        .btn-submit {
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: #ffffff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            transition: background-color 0.3s, transform 0.3s;
        }
        .btn-submit:hover {
            background-color: #0056b3;
            transform: scale(1.02);
        }
        .message {
            text-align: center;
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            font-size: 16px;
        }
        .message.success {
            color: #28a745;
            border: 1px solid #28a745;
            background-color: #d4edda;
        }
        .message.error {
            color: #dc3545;
            border: 1px solid #dc3545;
            background-color: #f8d7da;
        }
    </style>
</head>
<body>
    <div class="navbar">
       <div class="nav-links">
    <a href="give_book.php"><i class="fas fa-hand-holding-book"></i> Give Book</a>
    <a href="returnbook.php"><i class="fas fa-undo"></i> Return Book</a>
    <a href="Insert_book.php"><i class="fas fa-book"></i> Add New Book</a>
</div>

    </div>

    <div class="container">
        <h2><i class="fas fa-book"></i> Manage Book</h2>
        
        <!-- Search Form -->
        <form method="post" action="">
            <div class="form-group">
                <label for="book_no">Book Number</label>
                <input type="text" id="book_no" name="book_no" value="<?php echo htmlspecialchars($book_no); ?>" required>
            </div>
            <button type="submit" name="search" class="btn-submit"><i class="fas fa-search"></i> Search</button>
        </form>

        <!-- Edit Form -->
        <?php if ($book_no && isset($book_name) && $message != "<div class='message error'>This book cannot be edited as it is already given out.</div>"): ?>
            <form method="post" action="">
                <input type="hidden" name="book_no" value="<?php echo htmlspecialchars($book_no); ?>">
                <div class="form-group">
                    <label for="book_name">Book Name</label>
                    <input type="text" id="book_name" name="book_name" value="<?php echo htmlspecialchars($book_name); ?>" required>
                </div>
                <div class="form-group">
                    <label for="form">Form</label>
                    <input type="text" id="form" name="form" value="<?php echo htmlspecialchars($form); ?>">
                </div>
                <button type="submit" name="update" class="btn-submit"><i class="fas fa-save"></i> Save Changes</button>
            </form>
        <?php endif; ?>

        <?php echo $message; ?>
    </div>
</body>
</html>
